# PWA for WP - Progressive Web Apps Made Simple

Contributors: magazine3

Requires at least: 3.0

Tested up to: 6.8

Stable tag: 1.7.79

License: GPLv2 or later

License URI: http://www.gnu.org/licenses/gpl-2.0.html

Tags: PWA, Review, Progressive Web Apps, Mobile, Web Manifest, Manifest, Offline Support, Cache, Pagespeed, Service Worker, Web app, pwa


## Description 
PWA plugin is bringing the power of the Progressive Web Apps to the WP & AMP to take the user experience to the next level!

You can give the APP-like experience to your audience which will get your website to their home screen and works instantly like an APP with offline support.

## Features: 
* <strong>Swipe Navigation in PWA :</strong> Adds swipe left / right feature to load next and previous articles.
* <strong>WP Hide & Security Enhancer Compatibility </strong>
* <strong>Disable Scrollbar</strong>: Hide scrollbar in PWA app.
* <strong>AMP Support</strong>: Full PWA compatibility for AMP.  It works well with AMPforWP & AMP for WordPress by Automattic.
* NEW: Multi site support
* NEW: UTM Tracking
* NEW: OneSignal support with multisite
* NEW: Easily change start URL
* NEW: Caching Strategy for PWA enabled assets
* NEW: Added Support with PWA By PWA Plugin Contributors
* Cache Expire option added
* <strong>Service Worker </strong>: We have developed a service worker which automatically gets installed in the background and performs the necessary actions such as caching the external objects to reduce the requests and more.
* <strong>APP Banners in Home-screen</strong>: Automatically notifies your visitor to get the APP version of the website which directly gets added with the list of Apps and Home-screen. You can customize the icons for this as well.
* <strong>Web App Manifest</strong>: The Manifest file is necessary to get this functionality rolled out and we have made this automatic and connected with the PWA options.
* <strong>Offline Support</strong>: The PWA version of your site will load blazing fast even when the user is offline. Once the user is online, it will update the content again. It will also count the analytics as well and updates it when the user goes online again.
* <strong>Full Screen & Splash Screen</strong>: When you open the PWA version from the mobile, it will load in full screen without any browser toolbar, which gives it a native app like feel in PWA version. There’s also a welcome splash screen which is totally customizable.
* <strong>Continuous Development</strong>: We will be working hard to continuously develop this PWA solution and release updates constantly so that your forms can continue to work flawlessly.
* Dashboard System Status which helps you understand the setup status of the PWA.
* Application Icon Uploading
* Background color options for Splash screen
* Add your own Application and short name.
* Easily set the start page from options.
* Set Device Orientation easily.
* Tested with Google Lighthouse
* More PWA Features Coming soon.

* **[Premium]** the ability to expand PWA for WP with [Call to Action](https://pwa-for-wp.com/extensions/call-to-action-for-pwa/), [Loading Icon Library](https://pwa-for-wp.com/extensions/loading-icon-library-for-pwa/), [Data Analytics](https://pwa-for-wp.com/extensions/data-analytics-for-pwa/), [Pull to Refresh](https://pwa-for-wp.com/extensions/pull-to-refresh-for-pwa/), [Scroll Progress Bar](https://pwa-for-wp.com/extensions/scroll-progress-bar-for-pwa/), [PWA to APK Plugin](https://pwa-for-wp.com/extensions/pwa-to-apk-plugin/), [Offline Forms for PWA for WP](https://pwa-for-wp.com/extensions/offline-forms-for-pwa-for-wp/), [Navigation Bar for PWA](https://pwa-for-wp.com/extensions/navigation-bar-for-pwa/), [Quick Action for PWA](https://pwa-for-wp.com/extensions/quick-action-for-pwa/), [Multilingual Compatibility for PWA](https://pwa-for-wp.com/extensions/multilingual-compatibility-for-pwa/), [BuddyPress for PWA for WP](https://pwa-for-wp.com/extensions/buddypress-for-pwa-for-wp/), [Rewards on PWA Install](https://pwa-for-wp.com/extensions/rewards-on-pwa-install/), [QR Code for PWA](https://pwa-for-wp.com/extensions/qr-code-for-pwa/), [PWA to iOS Plugin](https://pwa-for-wp.com/extensions/pwa-to-ios-plugin/), and [Whitelabel for PWA ](https://pwa-for-wp.com/extensions/pwaforwp-white-label/) extensions

**We Act Fast on Feedback!**

We are actively developing this plugin and our aim is to make this plugin into the #1 solution for PWA in the world. You can [Request a Feature](https://github.com/ahmedkaludi/pwa-for-wp/issues) or [Report a Bug](https://pwa-for-wp.com/contact-us/).

**Technical Support**

Support is provided in [Forum](https://wordpress.org/support/plugin/pwa-for-wp). You can also [Contact us](https://pwa-for-wp.com/contact-us/), our turn around time on email is around 12 hours. 

**Would you like to contribute?**

You may now contribute to this PWA plugin on Github: [View repository](https://github.com/ahmedkaludi/pwa-for-wp) on Github

## Frequently Asked Questions

# How to install and use this PWA plugin? 
After you Active this plugin, and go the PWA Options Dashboard to see the status and setup options accordingly.  

# How do I report bugs and suggest new features? 
You can report the bugs for this PWA plugin [here](https://github.com/ahmedkaludi/pwa-for-wp/issues)

# Will you include features to my request? 

Yes, Absolutely! We would suggest you send your feature request by creating an issue in [Github](https://github.com/ahmedkaludi/pwa-for-wp/issues/new/) . It helps us organize the feedback easily.

# How do I get in touch? 
You can contact us from [here](https://pwa-for-wp.com/contact-us/)

## Changelog
== Changelog ==
= 1.7.79 (06 June 2025) =
* Enhancement : The firebase has changed the PN configurations, need to review #947
* Bug Fixed : File download filename shows [Object Attr] as filename #958
* Bug Fixed : White Label for PWA settings not showing #959

= 1.7.78 (21 April 2025) =
* Bug Fixed : Undefined array key "HTTP_USER_AGENT" /plugins/call-to-action-for-pwa/service/service.php #955
* Bug Fixed : Undefined array key "swipe_navigation" in PWA for WP 1.7.77
* Bug Fixed : Pull to refresh feature creating issue with Elementor page scroll option #952
* Test   : Test with WordPress version 6.8 #956

= 1.7.77 (13 March 2025) =
* Added  : Whitelabel For PWA (pro extension) #693
* Feature : Swipe left / right to load next and previous article #567
* Improvement  : update setting UI #697
* Improvement  : Readme update with new feature list #945
* Bug Fixed : CTA banner is showing incorrect Add to Home Steps in Chrome on an IOS device #946
* Bug Fixed  : Remove default banner and Remove PWA for logged-in users Both options are always checked by default. #941
* Bug Fixed  : PWA Installation Instructions Persist After Install & Cancel CTA Still Triggers Installation #951

= 1.7.76 (31 December 2024) =
* Added  : PWA to ios as a service (pro extension)#693
* Improvement  : Make a feature to force load the "pwa-non-amp-install" specific parameter URL. #932
* Bug Fixed  : Offline form feature not working in IOS. #937
* Improvement  : Scroll Progress Bar is not showing when PWA display mode is fullscreen #943
* Compatibility  : Need to add compatibility with Eform in offline forms #940
* Test   : Test with WordPress version 6.7 #936

= 1.7.75 (28 October 2024) =
* Improvement  : Added an option to edit the text in the iOS QR code #926
* Improvement  : Added an option to edit browser banner content. #934
* Bug Fixed  : Extensions not activating #929
* Improvement  : Added an option so that only the Steps to install the PWA on IOS should be visible directly without clicking on Install banner in CTA #922
* Bug Fixed   : The feature Quick Action is not working #931
* Improvement   : Minify JS files for production #933

= 1.7.74 (02 September 2024) =
* Bug Fixed  : The visibility option is not working for the CTA feature. #905
* Bug Fixed  : App Icon is getting replaced by Splash screen Icon on some Android devices #923
* Improvement  : Connect CTA with add to homescreen in chrome browser. #924
* Improvement  : Update 'Stable Tag' in readme.md file #908

= 1.7.73 (13 August 2024) =
* Bug Fixed  : Warning appears in Call to Action extension. #915
* Bug Fixed  : Fixed vulnerability issues discovered by Darius Sveikauskas.
* Compatibility  : Tested with WordPress version 6.6 #914.
* Improvement  : Code improvement.

= 1.7.72 (09 July 2024) =
* Bug Fixed  : The visibility option is not working for the CTA feature. #905
* Bug Fixed  : Navigation bar extension conflict issue #910
* Bug Fixed  : When we click on saving button on Nav bar data was not saved. #913
* Bug Fixed  : Fixed vulnerability issues discovered by CleanTalk inc.
* Improvement  : Code improvement.

= 1.7.71 (03 July 2024) =
* Feature Added  : Make an option to select form factor from the option #899
* Feature Added  : Sharing Media in Progressive Web Apps in BuddyPress #1591
* Bug Fixed  : Creation of dynamic property is deprecated #903
* Bug Fixed  : Deprecation : $is_amp is defined before require parameter #911

= 1.7.70 (15 May 2024) =
* Bug Fixed  : Uncaught TypeError: fwrite(): Argument #1 ($stream) must be of type resource, bool given in #888
* Bug Fixed  : Add to home on element click is not working when adding button via elementor #891
* Bug Fixed  : While clicking the close button on the CTA banner it shows the pop-up to install #893

= 1.7.69.1 (09 May 2024) =
* Bug Fixed  : PWA: Activation Failed error with wordpress latest update. #886

= 1.7.69 (22 April 2024) =
* Feature Added : added a new feature so that users can be able to upload their own images to use as an icon in the Navigation Bar #869
* Bug Fixed  : Latest Version 1.7.67 Gives Warning: Undefined Variable $force_rememberme #878

= 1.7.68 (05 April 2024) =
* Feature Added : added the navigation bar backgound feature. #874
* Bug Fixed  : Latest Version 1.7.67 Gives Warning: Undefined Variable $force_rememberme #878
* Bug Fixed  : CTA delayed feature is not working properly in IOS chrome mobile version. #879
* Bug Fixed  : Conflict issue with Polylang plugin #880

= 1.7.67 (26 March 2024) =
* Feature Added : New option so that category pages can be configured as the start page in PWA #861
* Improvement: Compatibility with WP-Hide plugin. #732
* Feature Added : Option where we can hide the navigation bar on certain pages. #868
* Compatibility : Tested with  WordPress 6.5 #876

= 1.7.66 (23 January 2024) =
* Improvement : Visibility improvement #858
* Bug Fixed  : offline form feature is not working with formidable forms. #862

= 1.7.65 (30 December 2023) =
* Bug Fixed  : The Text Font color and the Selected Text Font color of the Navigation Bar are not getting saved #855
* Bug Fixed  : Media Feature Errors in Blog Splash Screen Images Validation #832
* Feature Added  : Functionality to disable the Page navigation scroll bar in PWA #853
* Improvement : Code Improvemnt #856

= 1.7.64 (22 November 2023) =
* Improvement  : Make the offline message "You are offline" as an option #727
* Improvement  : Add support for prefer_related_applications #819
* Bug Fixed  : Conflict issue with the plugin Category Icon #851
* Feature Added  : Added browser option in Display #829
* Improvement : Added "Alt" attribute is missing in logo images #852
* Improvement : License key area should be proper #759

= 1.7.63 (16 October 2023) =
* Bug Fixed  : Offlineforms are not working with Contact Form7 #844
* Improvement  : Need to change menu icon for pwa #843
* Bug Fixed  : Warning appears in Offline Forms for PWAforWP extension. #840
* Feature Added  : Add compatibility with the Signature module and the Date-Time modules of fluent forms with offline forms for PWA #847

= 1.7.62 (14 Sept 2023) =
* Bug Fixed  : Push notification is not working on IOS. #66
* Bug Fixed  : Need to put a proper display message on license activation/deactivation timeout #831
* Bug Fixed  : The messages do not redirect when the extension Buddypress for PWAforWP is activated on the user-end #839
* Feature Added  : Need to create a feature for Role managers #824
* Feature Added  : Need to add support to display badge on mobile PWA icon #821
* Feature Added  : Need to add a new feature for BuddyPress Group Notification in buddypress for PWAforWP pro extension #841

= 1.7.61 (01 Sept 2023) =
* Bug Fixed  : QR code activation issue #827
* Bug Fixed  : Add logo in WordPress Menu for PWAforWP #803
* Bug Fixed  : PWA dashboard Enable / Disable option not working properly #820
* Bug Fixed  : Login header are visible after logout #826
* Bug Fixed  : Offline form issue with Formidable form #825
* Feature Added  : Option to upload multiple images in APP Screenshots section #807
* Feature Added  : Install Link for PWA for WP #735
* Feature Added  : Add a feature by which Search bar should work offline #815
* Feature Added  : Add a feature to force disable the pull to refresh on an Android device #814

= 1.7.60 (26 May 2023) =
* Bug Fixed  : Navigation Bar saving button is not working properly. #811
* Bug Fixed  : Conflict issue in loader extension #812
* Bug Fixed  : formidable forms File Upload feature is not supported in offline form #801

= 1.7.59 (05 May 2023) =
* Feature Added  : Label should be clickable for all checkbox labels #802
* Feature Added  : Add functionality that user can install app using QR Code #806

= 1.7.58 (20 April 2023) =
* Feature Added  : Add monochrome icons to manifest #795
* Feature Added  : Add "related_applications" to manifest #794
* Bug Fixed : Auto-save forms feature is not working properly. #799

= 1.7.57 (18 March 2023) =
* Bug Fixed  : Download button href changing into link attribute on click #790
* Bug Fixed  : Rewrite rules are being flush on every page load #765
* Bug Fixed  : Undefined function "pwaforwp_t_string" and undefined variable "pwaforwp_addon_license_info" #796

= 1.7.56 (16 February 2023) =
* Improvement: Code Improvement as per WP guidlines #787
* Bug Fixed  : The offline form is not working and shows an error after submitting. #789
* Bug Fixed  : Subscribe to push notification appears again and again after subscribing it.(User Specific) #751	
* Removed    : Removed Offer Banner #788

= 1.7.55 (26 December 2022) =
* Bug Fixed  : PWA loader is not working in iphone safari browser and macbook safari #664
* Bug Fixed  : Data Analytics does not count the PWAs downloaded when display mode is minimal-ui in Android. #750	

= 1.7.54 (16 December 2022) =
* Bug Fixed  : A2HS Shortcode shows only on iOS, not on desktop. #780
* Bug Fixed  : Offline forms throwing error  #779
* Bug Fixed  : Offline submission didn't work #685
* Bug Fixed  : Loader icon color and background color does noy change according to set color #781
* Added      : Added offline support for multistep gravity forms

= 1.7.53 (06 December 2022) =
* Bug Fixed  : CTA Short code is not working #768
* Bug Fixed  : The Option "Follow Device Orientation" is not working. #766
* Bug Fixed  : Splash screen icon is not working on IOS #724

= 1.7.52 (21 November 2022) =
* Bug Fixed  : While using FCM push notification, there is an error in the console. #741
* Improvement: Remove jQuery dependency in PWA plugin #743
* Improvement: Escaping is missing in some place #769 
* Improvement: Some functions are missing prefix #770 
* Improvement: Push notification Send Manual Notification Improvement #771
* New :BFCM internal offer #772 

= 1.7.51 (01 November 2022) =
* Improvement: Checkbox inside Default caching strategy should have some padding #761
* Improvement: styling is not right #726
* Bug Fixed: When we add the video to our website when the PWA plugin is enabled, there is an error in the console. #760

= 1.7.50 (11 October 2022) =
* Bug Fixed: When loader is enable then website and app take longer to load. #739
* Bug Fixed: CTA banner's install button is not working on desktop and android devices. (Sticky bar) #753

= 1.7.49 (10 August 2022) =
* Bug Fixed: Remove jQuery dependency in PWA plugin #743
* Bug Fixed: Force Update Service Worker is not working #742

= 1.7.48 (13 July 2022) =
* Bug Fixed: Buddypress downloading feature is not working with IOS PWA but it is works with safari. #713
* Bug Fixed: Need to add a option for the proper uninstallation of the plugin. #723

= 1.7.47 (02 June 2022) =
* Bug Fixed: Getting blank page when trying to access the BuddyBoss plugin using "Buddypress for PWAforWP" extension #704
* Bug Fixed: Video not playing with PWA #707
* Bug Fixed: IOS Splash Screen Method is not working. #717
* Improvement: Need to improve the visibility section tool tip #705
* Improvement: Need to change the To:- email in the Help tab. #718
* Improvement: Resolved jquery file issue

= 1.7.46 (23 April 2022) =
* Bug Fixed		: Fixed loader issue in IOS, desktop, mobile, admin, and only PWA #703, #700
* Bug Fixed		: Improvement when license is expired #696
* Bug Fixed		: Added option to add screenshots in manifest #694

= 1.7.45 (15 April 2022) =
* Added		: Added Visibility Feature
* Added		: Added Include and exclude condition in visibility feature

= 1.7.42 (21 February 2022) =
* BugFixed		: Removed new line issue, while exclude urls from cache
* BugFixed		: Loader icon will work properly
* BugFixed		: Added Compatibility for wp verion 5.9

= 1.7.41 (4 January 2022) =
* BugFixed		 : removed duplicate meta tag #676
* BugFixed		 : Loader show only in PWA with desktop|mobile #677
* BugFixed		 : Update Firebase library #681

= 1.7.40 (31 October 2021) =
* Added			 : Information rendered in admin option #662
* BugFixed		 : Onesignal Compatibility resolve with updated version 2.2.1 #659
* BugFixed		 : Issue resolve related to minify Service Worker while register #663

= 1.7.39 (15 October 2021) =
* Added			 : Other option for offline page, user can set custom page url. #526
* BugFixed		 : Hide PWA admin menu for other than admin users #655
* BugFixed 		 : Fixed Video not playing in PWA APP 

= 1.7.38 (20 September 2021) =
* BugFixed		 : multisite not register with offline mode
* BugFixed		 : Label show for apple splash screen checkbox #652
* BugFixed		 : Compatibility issue with Official AMP Transitional mode #651

= 1.7.36 (9 September 2021) =
* BugFixed		 : Service worker register issue with onesignal #643
* BugFixed		 : Service worker register issue in multisite with dynamic URLs #643
* Added			 : New Addon Rewards on PWA APP Install #475,#466,#182
* BugFixed		 : Pre-Caching option is automatic get disabled #649

= 1.7.36 (3 August 2021) =
* Added			 : Option to delete cookies from the cache #337
* Fixed 		 : Getting "untitled" instead of the app title name in iOS #638

= 1.7.35 (20 July 2021) =
* Added		 	 : PWA url handler for same origin urls #621
* Improvement 	 : apple icons html added hook #633
* Improvement 	 : Added hook for enable pushnotification feature

= 1.7.34 (10 July 2021) =
* Improvement 	 : Loader will shows in preview mode with elementor #629
* Added 		 : Multilingual Compatibility for PWA addon #408 #625 #388
* Improvement 	 : Added the feature to show the loader functionality only for PWA #625 

= 1.7.33 (24 June 2021) =
* Improvement 	 : To remove all data related with plugin, added uninstaller handle #623
* Improvement 	 : Modified the message for review #618
* Improvement 	 : Notices or messages related to PWA for WP should load only on settings pages #615
* Enhancement	 : Added quick action feature for PWA #566
* Enhancement	 : Added navigation tab bar feature for PWA web APPs #541
* BugFixed		 : On the fly service worker file serve issue with onesignal #622 
* Improvement 	 : Compressed the auto-generated Js/serviceworker file #556
* Improvement 	 : Applied more check before store any outside operation #626
* Improvement 	 : PWA admin notices will display only one notice at a time. #616

= 1.7.32 (22 May 2021) =
* BugFixed		 : Removed Warnings and notice for latest version of PHP #608
* BugFixed		 : Removed javascript warning  

= 1.7.31 (29 April 2021) =
* Improvement 	 : CTA issue with OneSignal compatibility #603
* Improvement 	 : File not update when OneSignal enabled #591
* BugFixed		 : Colors related fields values are not show alpha RGB colors #592
* BugFixed		 : splash icon is not generating for the IOS device #596


= 1.7.30 (15 March 2021) =
* Improvement 	 : OneSignal compatibility issue (resolve popup not appear with single/multi sites) #581
* Enhancement	 : Added Alpha options in color picker of PWA settings #575
* BugFixed		 : Loader not showing because of less z-index as compare to wrapper #578
* Enhancement	 : Add an option to select “apple-mobile-web-app-status-bar-style” property based on user requirement #580
* BugFixed		 : Resolve PWA APP not changes orientation as per device rotation.

= 1.7.29 (26 February 2021) =
* Enhancement	 : Integrated BuddyPress Notification with Push Notification in PWA #183
* Improvement 	 : Sets the style of the status bar for Full screen on iOS device #577
* Improvement 	 : Add the different markups for the regular icons and the maskable icons #573
* BugFixed		 : Compatible with Oxygen Gutenberg Integration Plugin #578
* BugFixed 		 : Loading icons are not loading at users end #568

= 1.7.28 (13 January 2021) =
* Improvement 	 : Added a few Offline notice/message features to the app or website #489
* Improvement 	 : Added prefetch option for manifest in HTML pages #564
* Fix 			 : Loader after refresh the content #552

= 1.7.27 (24 NOVEMBER 2020) =
* Improvement 	 : Minor update

= 1.7.26 (18 NOVEMBER 2020) =
* Improvement 	 : Improvement for Webpushr Plugin compatibility #513

= 1.7.24 (10 NOVEMBER 2020) =
* Added 	 : compatibility with Webpushr Plugin (Settings->Tools->Compatibility->Webpushr) #513

= 1.7.24 (04 NOVEMBER 2020) =
* Added 	 	: Added option to disable PWA for logged in users #543
* Added 	 	: Compatibility with the pushnami pushnotification #409

= 1.7.23 (26 OCTOBER 2020) =
* Bug Fixed     : An option added that would add a custom icon 96x96 for the notifications that are sent for budge(Replace chrome icon).  #517
* Improvement 	: FCM push notification Sending 2 times with Gutenberg editor & need a hook before sent message #547
* Improvement 	: Added an class to identify if its PWA "pwaforwp-app-contents", its will show only in PWA APP. #522
* Improvement 	: Added an option loader icon should also work in the backend #411

= 1.7.22 (12 OCTOBER 2020) =
* Bug Fixed     : Local video is not caching #444
* Improvement 	: Debug error fixed #520
* Improvement 	: Compatibility issues with AMP by Automattic. #522
* Improvement 	: If the Off line Google analytics option in the PWA option panel then showing workbox console error showing #524

= 1.7.21 (3 OCTOBER 2020) =
* Bug Fixed     : AMP Pages/post (Automattic) is getting blank page, when Loader feature is enabled #528
* Improvement 	: Added a option for loader background color change. #533
* Improvement 	: Issue with the Loading Icon alignment. #535
* Improvement 	: Hide license key of addons #530

= 1.7.20 (17 SEPTEMBER 2020) =
* Improvement   : Improved the UI of features section #462
* Improvement   : Added learn more link after the https status message of PWA  #464
* Improvement   : Provide option to switch default cache strategy for the user if they have login in the front end #461
* Improvement   : Change the UI of the after adding the splash screen automatically for the IOS #452
* Improvement   : Pull request for update readme.md #521

= 1.7.19 (05 SEPTEMBER 2020) =
* Bug Fixed     : service worker version after update option panel #478
* Bug Fixed     : Wrapped all the texts of the pwa-for-wp plugin in the text domain #493
* Bug Fixed     : Site Icon 180x180 is grabbing while installing the PWA in the iOS mobile devices #483
* Bug Fixed     : Message in the opt-in modal #492
* Bug Fixed     : FCM Push Notification is sending the notification even when the new post/page is unchecked in the options. #458

= 1.7.18.1 (29 JULY 2020) =
* Bug Fixed     : moved apple-touch-icon-precomposed icon with manifest #467  

= 1.7.18 (21 JULY 2020) =
* Feature added     : Added feature for Offline Forms for PWA for WP 

= 1.7.17.2 (14 JULY 2020) =
* Bug Fixed     : iOS splash screen resolution issue #453

= 1.7.17.1 (08 JULY 2020) =
* Bug Fixed     : Issue with 'X' button of custom add to home screen banner. #450
* Bug Fixed     : Site Icon from Customizer is duplicating the icon meta tag resulting in different icon on homescreen #442
* Bug Fixed     : when the app is opened Every time it is changeling for login. #446

= 1.7.17 (04 JULY 2020) =
* Bug Fixed     : Custom add to home screen banner is appearing on desktop. #438
* Bug Fixed     : App splash screen not loading on iOS devices. #249
* Bug Fixed     : iOS splash screen issue #410

= 1.7.16.1 (20 JUNE 2020) =
* Bug Fixed     : Warning Error: PHP Warning: count(): Parameter must be an array #437
* Bug Fixed     : User interface notation updated. #441
* Bug Fixed     : Maskable icon support in PWA #280
* Bug Fixed     : Removed tool tip #432
* Bug Fixed     : Add a “cursor: pointer” to Add to Home screen Button #440

= 1.7.16 (12 JUNE 2020) =
* Bug Fixed     : Extra spacing in Design tab under Setup #417
* Bug Fixed     : Apostrophe 'S is adding slash in the front end #418
* Bug Fixed     : Popup height issue in Sub settings under features section #416

= 1.7.15 (04 JUNE 2020) =
* Bug Fixed     : Status showing incorrect data in PWA main settings #414
* Bug Fixed		: Add to Home Screen popup should not appear in Offline PWA App #400
* Bug Fixed		: "Add To Home screen" popup is not showing on AMP #397

= 1.7.14.1 (28 MAY 2020) =
* Bug Fixed     : convert &amp; to & character in PWA site title in manifest #406

= 1.7.14 (23 MAY 2020) =
* Improvement   : Addons are showing require pro even after the extension manager is activated with a key. #381
* Improvement   : redirect to the "Extension Manager" section after clicking on the "Premium Features" when user have pwa addon manager #395
* Improvement   : flywheel directory path compatibility #399
* Bug Fixed     : Added an option to disable the automatic add to home screen pop #398
* Bug Fixed     : FCM push notification key generation issue fixed #372
* Bug Fixed     : Add to Home Screen popup should not show after adding PWA app #395

= 1.7.13 (15 MAY 2020) =
* Improvement   : pwa-amp-sw.html is able to view in the Google analytics #389
* Improvement   : Update the user experience of premium features tab contents on pro extension exists #378
* Improvement   : Improved performance #354
* Improvement   : App Icon should be load in last. #362

= 1.7.12 (11 MAY 2020) =
* Bug Fixed	  : pwa menu is enabled the menu gets aligned to full width #377
* Bug Fixed	  : pwa Pushnotification.io after installation go to settings link #377
* Improvement : pwa Endpoint changes #368
* Bug Fixed	  : Custom add to home screen banner should not appear if it in IOs #382

= 1.7.11.1 (02 MAY 2020) =
* minor update

= 1.7.11 (02 MAY 2020) =
* Bug Fixed	  : Resolve multiple time occurrence issue with review message #360
* Bug Fixed	  : APP Icons and other data should be load in last. #362
* Bug Fixed   : window is not UX friendly added scroll css to show scroll bar #361
* Bug Fixed   : Added more sanitization to block sql injection in alternative method of Service worker serve #376 #364
* Bug Fixed   : preview not loading in elementor in edit mode #373

= 1.7.10 (25 APRIL 2020) =
* Bug Fixed	  : Removed debug notice

= 1.7.9.3.2 (15 APRIL 2020) =
* Bug Fixed	  : Custom banners close not working on static scroll banner #357

= 1.7.9.3.1 (31 March 2020) =
* Bug Fixed   : Security patch: Service worker file read permission updated

= 1.7.9.3 (19 March 2020) =
* Added	  	  : Add to Home screen banner for No scroll view website #346
* Bug Fixed   : Fixed Upload Theme button in Appearance. #350
* Bug Fixed   : Push notification is sending to user even after disabling this feature. #272

= 1.7.9.2 (6 March 2020) =
* Bug Fixed	  : Removed javascript issue for call to action banner  #343

= 1.7.9.1 (2 March 2020) =
* Improvement : Minor bug fixes

= 1.7.9 (25 February 2020) =
* Added	  	  : Added Image field in send push notification #342
* Added	  	  : In Notification while create or update post featured image will send as big image #342
* Added 	  : Add image option in Send manual notification with FCM integration #325
* Improvement : Minor code improvement

= 1.7.8.1 (19 February 2020) =
* Bug Fixed	  : Html cannot fetch properly #342
* Bug Fixed   : manifest not working with multisite after performance resolve #341

= 1.7.8 (17 February 2020) =
* Resolved	  : Remove JQuery dependency from Front-end #330
* Bug Fixed   : while install with Pushnotification.io integration does not activate the plugin if already exists #338
* Added 	  : Added an option asking were to show the loader only in mobile or in desktop #307
* Improvement : Performance Resolve, call of PWA manifest JSON will load via static file if permission exists #336
* Bug Fixed   : 404 Page not showing Network only and network first caching strategies #334

= 1.7.7 (04 February 2020) =
* Improvement : Moved Call to action options in Features tabs #313
* Bug Fixed   : In background service worker when Push notifications are Selected and FCM keys are filled then also only one of either setting should be loaded in PWA, not both. #326
* Resolved    : Features tab modal design issue like contents goes out, submit button not shows #328
* Added 	  : Option to change color of the 'loader icons' #312
* Added 	  : Added apple-touch-icon-precomposed rel link in the head tag for apple app icon #321

= 1.7.6 (18 January 2020) =
* Resolved    : Fatal error of Cannot redeclare checkStatus() function #297
* Bug Fixed   : After Selection of pushnotification.io also shows options of FCM if user previously using FCM integration #304
* Improvement : AMP proper support with pushnotification.io version 1.6 support #303 
* Resolved    : Wordpress Multi site always show Service worker status "Click here to setup" #298
* Fixed       : Refresh the content when default strategy is Network first from Inside APP first opening #306
* Added       : Option to user can stop or allow to share data #297
* Resolved	  : Add to Home screen custom banner is not showing in Samsung default browsers(PWA Support Dependent) #296

= 1.7.5 (11 January 2020) =
* Bug Fixed : PWA CTA bar shows behind default browser banner due in AMP #275
* Improved : Manifest loading issue if REST API not disabled #292

= 1.7.4.4 (7 January 2020) =
* Minor changes
* Bug Fixed : PWA not shows on home/front page with amp by Automattic  #288

= 1.7.4.3 (6 January 2020) =
* Feature   : Compatibility with AMP-WP by Pixelative #273
* Bug Fixed : Minor bug fixed #15 #274
* Bug Fixed : Resolve issue of 301 redirection pages on Network Only and Network First caching strategy #277
* Bug Fixed : Issue fixed with buddy press message not sending #286


= 1.7.4.2 (26 December 2019) =
* Feature 	: pushnotification.io Compatibility added #281 #283
* Bug Fixed : "Uncaught ReferenceError: pwa_cta_assets is not defined" in console #279
* Bug Fixed : PWA service worker time taking to load the page (Cache strategy) #276

= 1.7.4.1 (7 December 2019) =
* Improved 	: Display PWA CTA in Mobile version only #252
* Bug Fixed : UTM tracking referral not set for PWA APP #262

= 1.7.4 (4 December 2019) =
* Improved 	: Caching Strategy for network first and network only #263
* Bug Fixed : Form submit or any post Request check Added #271
* Added 	: Auto icon cropping feature automatically. if 192x192 icon added #224

= 1.7.3.3 (28 November 2019) =
* Fixed 	: Fixed SW file serve dynamically with ngnix servers #239

= 1.7.3.2 (25 November 2019) =
* Feature 	: Added support with `pwa By PWA Plugin Contributors` #107

= 1.7.3.1 (21 November 2019) =
* Improved 	: Disable Default Add to Home bar #241
* BugFixed  : After deactivating switch of push notification remove all code of push notification #231
* BugFixed  : loader Icon not shows in IOS (JS event not working) #244
* BugFixed  : CTA Bar will disable for 5 min when click on cross the button #248
* BugFixed  : Cache strategies & service worker loading as per the wordpress standard #260

= 1.7.3 (16 November 2019) =
* Fixed 	: PWA options are not Save in wordpress version 5.3 #253
* Improved  : Improve the Caching Strategies #246

= 1.7.2.1 (13 November 2019) =
* BugFixed : Meta title name not appears #243
* Added    : Compatibity With amp by automatic plugin in all mode #237
* BugFixed : Resolved fatal Error of Call to undefined function get_filesystem_method() Realted to #217 

= 1.7.2 (9 November 2019) =
* Improved : Loader disable is not working #228
* Improved : Service worker template file not readable #238
* Improved : Service worker cache file not update on users end #240
* Bug Fixed: FCM Config values not saving properly #217

= 1.7.1.2 (22 October 2019) =
* Improved : Custom Add to Homescreen Responsive

= 1.7.1.1 (17 October 2019) =
* Improved : Added note for Add To Home On Element Click #208
* Improved : Added "apple-touch-startup-image" icon and cache the image previously to load fast For IOS devices #212
* Bug Fixed: Improved upgrade to premium link #214
* Improved : Pre-caching list automated now. On publish post precache list will be updated #215
* Bug Fixed: Enable/Disable checkbox of the PWA on AMP or Non-AMP #216
* Bug Fixed: Fixed the license key error while activating Loading Icon Plugins #218

= 1.7.1 (12 October 2019) =
* Improved: UX design of option panel #203
* Improved & Added: Loading icons library added #100 #123 #205

= 1.7 (3 October 2019) =
* Added:	 Options to add IOS splash screen for different different screen sizes #179
* Bug Fixed: PWA addons panel improvement #196 
* Improved:	 Added support for cdn support with autooptimize #195

= 1.6 (26 September 2019) =
* Bug Fixed: PWA service worker register with onesignal, Call to action for pwa feature #191 
* Bug Fixed: Service worker with Onesignal on single site #193
* Improved:  Added aletrnative method for service worker blocked by cache  #178
* Bug Fixed: Custom add to HomeScreen Banner,add to HomeScreen on element with oneSignal in multisite #189 #188
* Added:     RTL Support #185

= 1.5.1 (20 September 2019) =
* Bug Fixed: Added option to enable disabled PWA in normal non-amp #190
* Bug Fixed: AMP multisite service worker URL serving 
* Improved:  UTM parameter properly added

= 1.5 (19 September 2019) =
* Improved:  Video play with PWA caching support for streaming contents #136
* Added:  	 Added auto & fullscreen options in orientation, display respectively #94 #96
* Improved:  Serviceworker and other files will display properly even it does not have write permission. #176
* Improved:  PWA working along with onesignal when used with multisite network #169
* Added: 	 Added text for translate in add to home screen banner #174
* Added: 	 The closing button option for Add to Homescreen Banner #156
* Added: 	 Tooltip for PWA option with there tutorials links #170
* Added: 	 Manual push notification default title will be website name.
			 Push notification popup icon should be changable #89

= 1.4 (12 September 2019) =
* Improved: Serve required files from dynamically #149
* Improved:  Add to homescreen icon showing blank in iphone(apple-touch-icon) #113
* Bug Fixed: Landscape orientation is not working in PWA correctly #151
* Bug Fixed: Showing "//" when adding to home screen in Firefox browser(start url) #147
* Added: Upgrade to premium as a menu item in the PWA #174

= 1.3.2 (9 September 2019) =
* Bug Fixed: Fatal error in multisite #167

= 1.3.1 (7 September 2019) =
* Added: Caching strategists documentation #152
* Improved: Option panel improvements #166

= 1.3 (6 September 2019) =
* Added: Option to change start page URL #153
* Feature: Onesignal fully compatible with multisites #164
* Bug Fixed: Service worker installation issue when home url & site url not same #160
* Improved: Multisite service worker installation #163

= 1.2.1 (10 July 2019) =

* Bug Fixed: If CDN compatiblity is enabled, Layout of the website is broken in AMP #140

= 1.2 (04 July 2019) =
* Bug Fixed: Delete the pwaforwp required files on uninstallation #141
* Bug Fixed: Click here to setup for particular file should have setup Instruction link and message. #142
* Bug Fixed: If CDN compatiblity is enabled, Layout of the website is broken #140
* Bug Fixed: AMP pages are broken on normal refresh. #139
* Bug Fixed: If https status is valid and app icon URL is HTTP then redirect it as HTTPS #133
* Bug Fixed: UTM tracking issue in PWA (Campaign parameter has been added) #114
* Bug Fixed: Home url issue #126

= 1.1 (19 June 2019) =
* Added: Manual notification title & app icon in push notification #125
* Added: Option to download required files when file creation permission is not there #108
* Improvements: Increase pre-caching post limit from 50 to unlimited #124
* Bug Fixed: PHP Notice: Undefined index: #119
* Bug Fixed: messaging/permission-blocked and push notification issues in the PWA for a user #104
* Bug Fixed: Enter Urls To Be Cached is showing backend links instead of actual links #102
* Bug Fixed: One Signal issues with Progressive Web Apps (Currently, PWA For WP & AMP is compatible with single site using oneSignal and multisite without oneSignal ( https://wordpress.org/plugins/onesignal-free-web-push-notifications/ )) #81


= 1.0.9 (25 March 2019) =

* Bug Fixed: Security improvement.

= 1.0.8 (01 March 2019) =
* Added     : Option to customize push notification title.
* Bug Fixed : PWA plugin using Firebase’s Development SDK? #78
* Bug Fixed : Un-visited images are not getting pre-cached when pre-cache option is enabled #80

= 1.0.7.1 (04 February 2019) =

* Bug Fixed : On post update – Push notification shows post link but takes to blog home page #77


= 1.0.7 (01 February 2019) =

* Bug Fixed : CDN Compatibility is not working on multisite #71
* Bug Fixed : Cache only for visitors but not logged in users? #68
* Bug Fixed : After updating post/page, the service worker still loads the stale post/page from old cache. #75
* Bug Fixed : Url issue with multisite ( service worker is getting main domain path for all subdomain path ) #72



= 1.0.6 (23 January 2019) =
* Added: Loading icon option has been added inside tools tab.
* Added: Reset option has been added inside tools tab.
* Added: Option added inside Advanced tab to cache the request url from an external domain.
* Improvements: Notice box to ask for review in day interval will not be shown again, if users click no thanks button 
* Bug Fixed : Js console error ( Uncaught ReferenceError: btnAdd is not defined ) #65
* Bug Fixed : PWA jumps to the browser in amp ( Now PWA in amp will redirect its link to native PWA app nor browser) #57
* Bug Fixed : If site and wordpress url is different, PWA can not be installed #63



= 1.0.5 (20 December 2018) =
* New Feature: Compatible with AMP for WordPress ( https://wordpress.org/plugins/amp ) 
* New Feature: Pre Caching - Now the latest number of posts can be pre cached on users end on their first visit. 
* Option to hide and show custom add to home banner on desktop
* Properly prepared for localization to make plugin translatable
* Bug Fixed : This page does not respond with offline #58

= 1.0.4 (27 November 2018) =
* New Feature: Custom responsive add to home banner.
* New Feature: Force update service worker option (This option updates service worker for all users who have installed at once)
* Offline Google Analytics options
* Improvements in CDN compatibility


= 1.0.3.1 (12 November 2018) =
* Custom Trigger for "Add to Homescreen" bug fixed
* Exclude the urls from Cache list bug fixed
* And Minor bugs fixed


= 1.0.3 (26 October 2018) =
* New Feature: Push Notification using firebase
* Added notifcations to review on day interval
* Custom Trigger for "Add to Homescreen"
* Exclude the urls from Cache list
* And Minor bugs fixed

= 1.0.2 (28 September 2018) =
* Apple touch Icons Support #25
* UTM Tracking feature 
* Contact form added so we can help people faster
* Cache Expire time option added 
* Caching Strategy option added
* Improved Add to homescreen option with proper Mini info bar support.
* and Minor bugs fixed

= 1.0.1 (27 August 2018) =
* You can choose to enable PWA compatibility either on AMP or Non-AMP or both.
* CDN Compatibility Added - Service Worker Works perfectly, even with the CDN. https://github.com/ahmedkaludi/pwa-for-wp/issues/9
* Optin added - Service Worker Works perfectly, https://github.com/ahmedkaludi/pwa-for-wp/issues/7
* Manifest of PWA was getting override when there is onesignal Manifest in the bottom of the Code: https://github.com/ahmedkaludi/pwa-for-wp/issues/4
* Minor bugs fixed

= 1.0 (16 August 2018) =
* Version 1.0 Released